import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ValidadorDespositosIndividuales {
	

	private int totalLines = 0;
	private BigDecimal totalSum = new BigDecimal(0);
	private BigDecimal headerSum = new BigDecimal(0);
	private SimpleDateFormat sdf;
	private final static String [][] matrizCiudades= {{"00", "000"}, {"23","815"}, {"05",	"001"}, {"08",	"001"}, {"11",	"001"}, {"13",	"001"}, {"15",	"001"}, {"17",	"001"}, {"18",	"001"}, {"19",	"001"}, {"20",	"001"}, {"23",	"001"}, {"25",	"001"}, {"27",	"001"}, {"41",	"001"}, {"44",	"001"}, {"47",	"001"}, {"50",	"001"}, {"52",	"001"}, {"54",	"001"}, {"63",	"001"}, {"66",	"001"}, {"68",	"001"}, {"70",	"001"}, {"73",	"001"}, {"76",	"001"}, {"81",	"001"}, {"85",	"001"}, {"86",	"001"}, {"88",	"001"}, {"91",	"001"}, {"94",	"001"}, {"95",	"001"}, {"97",	"001"}, {"99",	"001"}, {"05",	"002"}, {"54",	"003"}, {"05",	"004"}, {"13",	"006"}, {"27",	"006"}, {"41",	"006"}, {"50",	"006"}, {"85",	"010"}, {"20",	"011"}, {"17",	"013"}, {"20",	"013"}, {"41",	"013"}, {"68",	"013"}, {"85",	"015"}, {"95",	"015"}, {"41",	"016"}, {"25",	"019"}, {"52",	"019"}, {"41",	"020"}, {"68",	"020"}, {"76",	"020"}, {"05",	"021"}, {"15",	"022"}, {"19",	"022"}, {"52",	"022"}, {"73",	"024"}, {"27",	"025"}, {"95",	"025"}, {"41",	"026"}, {"73",	"026"}, {"18",	"029"}, {"05",	"030"}, {"13",	"030"}, {"47",	"030"}, {"73",	"030"}, {"05",	"031"}, {"20",	"032"}, {"05",	"034"}, {"25",	"035"}, {"44",	"035"}, {"05",	"036"}, {"52",	"036"}, {"76",	"036"}, {"05",	"038"}, {"05",	"040"}, {"25",	"040"}, {"76",	"041"}, {"05",	"042"}, {"13",	"042"}, {"17",	"042"}, {"73",	"043"}, {"05",	"044"}, {"05",	"045"}, {"20",	"045"}, {"66",	"045"}, {"15",	"047"}, {"17",	"050"}, {"19",	"050"}, {"27",	"050"}, {"05",	"051"}, {"15",	"051"}, {"52",	"051"}, {"54",	"051"}, {"68",	"051"}, {"13",	"052"}, {"25",	"053"}, {"47",	"053"}, {"76",	"054"}, {"05",	"055"}, {"73",	"055"}, {"47",	"058"}, {"05",	"059"}, {"20",	"060"}, {"13",	"062"}, {"81",	"065"}, {"73",	"067"}, {"23",	"068"}, {"27",	"073"}, {"13",	"074"}, {"19",	"075"}, {"27",	"075"}, {"66",	"075"}, {"27",	"077"}, {"68",	"077"}, {"08",	"078"}, {"41",	"078"}, {"44",	"078"}, {"05",	"079"}, {"23",	"079"}, {"52",	"079"}, {"68",	"079"}, {"68",	"081"}, {"52",	"083"}, {"05",	"086"}, {"25",	"086"}, {"15",	"087"}, {"05",	"088"}, {"17",	"088"}, {"66",	"088"}, {"15",	"090"}, {"23",	"090"}, {"44",	"090"}, {"05",	"091"}, {"15",	"092"}, {"68",	"092"}, {"05",	"093"}, {"18",	"094"}, {"25",	"095"}, {"15",	"097"}, {"44",	"098"}, {"25",	"099"}, {"27",	"099"}, {"54",	"099"}, {"19",	"100"}, {"76",	"100"}, {"05",	"101"}, {"68",	"101"}, {"15",	"104"}, {"15",	"106"}, {"05",	"107"}, {"15",	"109"}, {"54",	"109"}, {"76",	"109"}, {"19",	"110"}, {"44",	"110"}, {"50",	"110"}, {"52",	"110"}, {"70",	"110"}, {"63",	"111"}, {"76",	"111"}, {"05",	"113"}, {"76",	"113"}, {"15",	"114"}, {"05",	"120"}, {"25",	"120"}, {"68",	"121"}, {"76",	"122"}, {"25",	"123"}, {"50",	"124"}, {"70",	"124"}, {"73",	"124"}, {"05",	"125"}, {"54",	"125"}, {"85",	"125"}, {"25",	"126"}, {"76",	"126"}, {"54",	"128"}, {"05",	"129"}, {"19",	"130"}, {"63",	"130"}, {"76",	"130"}, {"15",	"131"}, {"41",	"132"}, {"68",	"132"}, {"05",	"134"}, {"15",	"135"}, {"27",	"135"}, {"85",	"136"}, {"08",	"137"}, {"19",	"137"}, {"05",	"138"}, {"85",	"139"}, {"13",	"140"}, {"08",	"141"}, {"05",	"142"}, {"19",	"142"}, {"05",	"145"}, {"05",	"147"}, {"68",	"147"}, {"76",	"147"}, {"05",	"148"}, {"25",	"148"}, {"73",	"148"}, {"05",	"150"}, {"18",	"150"}, {"27",	"150"}, {"50",	"150"}, {"25",	"151"}, {"68",	"152"}, {"73",	"152"}, {"05",	"154"}, {"25",	"154"}, {"13",	"160"}, {"27",	"160"}, {"68",	"160"}, {"47",	"161"}, {"97",	"161"}, {"15",	"162"}, {"23",	"162"}, {"68",	"162"}, {"85",	"162"}, {"68",	"167"}, {"23",	"168"}, {"25",	"168"}, {"73",	"168"}, {"68",	"169"}, {"47",	"170"}, {"66",	"170"}, {"05",	"172"}, {"15",	"172"}, {"54",	"172"}, {"17",	"174"}, {"54",	"174"}, {"20",	"175"}, {"25",	"175"}, {"15",	"176"}, {"68",	"176"}, {"20",	"178"}, {"25",	"178"}, {"68",	"179"}, {"15",	"180"}, {"25",	"181"}, {"23",	"182"}, {"15",	"183"}, {"25",	"183"}, {"15",	"185"}, {"15",	"187"}, {"13",	"188"}, {"15",	"189"}, {"23",	"189"}, {"47",	"189"}, {"05",	"190"}, {"63",	"190"}, {"68",	"190"}, {"05",	"197"}, {"25",	"200"}, {"73",	"200"}, {"95",	"200"}, {"52",	"203"}, {"15",	"204"}, {"70",	"204"}, {"18",	"205"}, {"27",	"205"}, {"47",	"205"}, {"05",	"206"}, {"41",	"206"}, {"54",	"206"}, {"52",	"207"}, {"68",	"207"}, {"05",	"209"}, {"68",	"209"}, {"52",	"210"}, {"68",	"211"}, {"05",	"212"}, {"13",	"212"}, {"15",	"212"}, {"19",	"212"}, {"63",	"212"}, {"25",	"214"}, {"15",	"215"}, {"52",	"215"}, {"70",	"215"}, {"68",	"217"}, {"73",	"217"}, {"15",	"218"}, {"86",	"219"}, {"81",	"220"}, {"70",	"221"}, {"13",	"222"}, {"15",	"223"}, {"50",	"223"}, {"54",	"223"}, {"15",	"224"}, {"25",	"224"}, {"52",	"224"}, {"85",	"225"}, {"15",	"226"}, {"50",	"226"}, {"73",	"226"}, {"52",	"227"}, {"20",	"228"}, {"68",	"229"}, {"70",	"230"}, {"85",	"230"}, {"15",	"232"}, {"52",	"233"}, {"70",	"233"}, {"76",	"233"}, {"05",	"234"}, {"68",	"235"}, {"70",	"235"}, {"15",	"236"}, {"73",	"236"}, {"05",	"237"}, {"15",	"238"}, {"20",	"238"}, {"54",	"239"}, {"05",	"240"}, {"52",	"240"}, {"76",	"243"}, {"13",	"244"}, {"15",	"244"}, {"41",	"244"}, {"25",	"245"}, {"27",	"245"}, {"47",	"245"}, {"50",	"245"}, {"54",	"245"}, {"68",	"245"}, {"76",	"246"}, {"18",	"247"}, {"13",	"248"}, {"15",	"248"}, {"76",	"248"}, {"05",	"250"}, {"20",	"250"}, {"27",	"250"}, {"52",	"250"}, {"54",	"250"}, {"68",	"250"}, {"76",	"250"}, {"85",	"250"}, {"50",	"251"}, {"52",	"254"}, {"68",	"255"}, {"18",	"256"}, {"19",	"256"}, {"52",	"256"}, {"25",	"258"}, {"47",	"258"}, {"52",	"258"}, {"25",	"260"}, {"52",	"260"}, {"54",	"261"}, {"85",	"263"}, {"91",	"263"}, {"05",	"264"}, {"68",	"264"}, {"70",	"265"}, {"05",	"266"}, {"68",	"266"}, {"13",	"268"}, {"47",	"268"}, {"73",	"268"}, {"25",	"269"}, {"50",	"270"}, {"73",	"270"}, {"68",	"271"}, {"15",	"272"}, {"17",	"272"}, {"63",	"272"}, {"73",	"275"}, {"76",	"275"}, {"15",	"276"}, {"68",	"276"}, {"25",	"279"}, {"44",	"279"}, {"85",	"279"}, {"25",	"281"}, {"05",	"282"}, {"73",	"283"}, {"05",	"284"}, {"25",	"286"}, {"50",	"287"}, {"52",	"287"}, {"25",	"288"}, {"47",	"288"}, {"19",	"290"}, {"25",	"290"}, {"15",	"293"}, {"25",	"293"}, {"20",	"295"}, {"25",	"295"}, {"08",	"296"}, {"15",	"296"}, {"68",	"296"}, {"25",	"297"}, {"41",	"298"}, {"68",	"298"}, {"15",	"299"}, {"25",	"299"}, {"13",	"300"}, {"19",	"300"}, {"23",	"300"}, {"81",	"300"}, {"85",	"300"}, {"63",	"302"}, {"05",	"306"}, {"41",	"306"}, {"76",	"306"}, {"25",	"307"}, {"68",	"307"}, {"05",	"308"}, {"05",	"310"}, {"20",	"310"}, {"25",	"312"}, {"05",	"313"}, {"50",	"313"}, {"54",	"313"}, {"05",	"315"}, {"85",	"315"}, {"15",	"317"}, {"25",	"317"}, {"52",	"317"}, {"05",	"318"}, {"19",	"318"}, {"47",	"318"}, {"50",	"318"}, {"66",	"318"}, {"68",	"318"}, {"76",	"318"}, {"41",	"319"}, {"73",	"319"}, {"25",	"320"}, {"52",	"320"}, {"68",	"320"}, {"86",	"320"}, {"05",	"321"}, {"15",	"322"}, {"25",	"322"}, {"68",	"322"}, {"52",	"323"}, {"25",	"324"}, {"68",	"324"}, {"15",	"325"}, {"50",	"325"}, {"85",	"325"}, {"25",	"326"}, {"68",	"327"}, {"25",	"328"}, {"50",	"330"}, {"15",	"332"}, {"25",	"335"}, {"25",	"339"}, {"94",	"343"}, {"54",	"344"}, {"68",	"344"}, {"05",	"347"}, {"54",	"347"}, {"73",	"347"}, {"41",	"349"}, {"73",	"349"}, {"23",	"350"}, {"50",	"350"}, {"52",	"352"}, {"73",	"352"}, {"05",	"353"}, {"52",	"354"}, {"19",	"355"}, {"52",	"356"}, {"41",	"357"}, {"41",	"359"}, {"05",	"360"}, {"05",	"361"}, {"27",	"361"}, {"15",	"362"}, {"05",	"364"}, {"19",	"364"}, {"76",	"364"}, {"15",	"367"}, {"05",	"368"}, {"15",	"368"}, {"25",	"368"}, {"68",	"368"}, {"50",	"370"}, {"68",	"370"}, {"08",	"372"}, {"25",	"372"}, {"27",	"372"}, {"05",	"376"}, {"15",	"377"}, {"25",	"377"}, {"54",	"377"}, {"68",	"377"}, {"76",	"377"}, {"41",	"378"}, {"44",	"378"}, {"52",	"378"}, {"05",	"380"}, {"15",	"380"}, {"17",	"380"}, {"52",	"381"}, {"20",	"383"}, {"66",	"383"}, {"52",	"385"}, {"54",	"385"}, {"68",	"385"}, {"25",	"386"}, {"17",	"388"}, {"05",	"390"}, {"52",	"390"}, {"19",	"392"}, {"25",	"394"}, {"41",	"396"}, {"19",	"397"}, {"68",	"397"}, {"25",	"398"}, {"54",	"398"}, {"52",	"399"}, {"05",	"400"}, {"20",	"400"}, {"50",	"400"}, {"66",	"400"}, {"70",	"400"}, {"76",	"400"}, {"85",	"400"}, {"15",	"401"}, {"63",	"401"}, {"25",	"402"}, {"15",	"403"}, {"76",	"403"}, {"52",	"405"}, {"54",	"405"}, {"91",	"405"}, {"68",	"406"}, {"15",	"407"}, {"25",	"407"}, {"91",	"407"}, {"73",	"408"}, {"18",	"410"}, {"85",	"410"}, {"05",	"411"}, {"52",	"411"}, {"73",	"411"}, {"27",	"413"}, {"23",	"417"}, {"19",	"418"}, {"52",	"418"}, {"54",	"418"}, {"68",	"418"}, {"70",	"418"}, {"23",	"419"}, {"44",	"420"}, {"08",	"421"}, {"05",	"425"}, {"15",	"425"}, {"27",	"425"}, {"68",	"425"}, {"25",	"426"}, {"52",	"427"}, {"70",	"429"}, {"13",	"430"}, {"25",	"430"}, {"27",	"430"}, {"44",	"430"}, {"85",	"430"}, {"91",	"430"}, {"68",	"432"}, {"08",	"433"}, {"13",	"433"}, {"17",	"433"}, {"52",	"435"}, {"08",	"436"}, {"25",	"436"}, {"25",	"438"}, {"05",	"440"}, {"13",	"440"}, {"66",	"440"}, {"85",	"440"}, {"13",	"442"}, {"15",	"442"}, {"17",	"442"}, {"20",	"443"}, {"73",	"443"}, {"17",	"444"}, {"68",	"444"}, {"17",	"446"}, {"73",	"449"}, {"19",	"450"}, {"27",	"450"}, {"50",	"450"}, {"15",	"455"}, {"19",	"455"}, {"66",	"456"}, {"13",	"458"}, {"18",	"460"}, {"47",	"460"}, {"91",	"460"}, {"73",	"461"}, {"15",	"464"}, {"23",	"464"}, {"68",	"464"}, {"15",	"466"}, {"23",	"466"}, {"05",	"467"}, {"13",	"468"}, {"68",	"468"}, {"15",	"469"}, {"63",	"470"}, {"13",	"473"}, {"19",	"473"}, {"25",	"473"}, {"52",	"473"}, {"70",	"473"}, {"05",	"475"}, {"15",	"476"}, {"18",	"479"}, {"05",	"480"}, {"15",	"480"}, {"52",	"480"}, {"54",	"480"}, {"05",	"483"}, {"25",	"483"}, {"41",	"483"}, {"73",	"483"}, {"17",	"486"}, {"25",	"486"}, {"25",	"488"}, {"25",	"489"}, {"05",	"490"}, {"13",	"490"}, {"52",	"490"}, {"15",	"491"}, {"25",	"491"}, {"27",	"491"}, {"15",	"494"}, {"05",	"495"}, {"17",	"495"}, {"27",	"495"}, {"76",	"497"}, {"54",	"498"}, {"68",	"498"}, {"15",	"500"}, {"23",	"500"}, {"68",	"500"}, {"05",	"501"}, {"68",	"502"}, {"41",	"503"}, {"73",	"504"}, {"25",	"506"}, {"52",	"506"}, {"15",	"507"}, {"70",	"508"}, {"15",	"511"}, {"97",	"511"}, {"17",	"513"}, {"19",	"513"}, {"25",	"513"}, {"15",	"514"}, {"15",	"516"}, {"19",	"517"}, {"20",	"517"}, {"15",	"518"}, {"25",	"518"}, {"41",	"518"}, {"54",	"518"}, {"08",	"520"}, {"52",	"520"}, {"54",	"520"}, {"73",	"520"}, {"76",	"520"}, {"15",	"522"}, {"68",	"522"}, {"70",	"523"}, {"17",	"524"}, {"25",	"524"}, {"41",	"524"}, {"68",	"524"}, {"99",	"524"}, {"25",	"530"}, {"41",	"530"}, {"91",	"530"}, {"15",	"531"}, {"19",	"532"}, {"15",	"533"}, {"19",	"533"}, {"68",	"533"}, {"25",	"535"}, {"91",	"536"}, {"15",	"537"}, {"52",	"540"}, {"91",	"540"}, {"05",	"541"}, {"17",	"541"}, {"47",	"541"}, {"15",	"542"}, {"05",	"543"}, {"47",	"545"}, {"68",	"547"}, {"73",	"547"}, {"19",	"548"}, {"41",	"548"}, {"63",	"548"}, {"08",	"549"}, {"13",	"549"}, {"68",	"549"}, {"15",	"550"}, {"20",	"550"}, {"41",	"551"}, {"47",	"551"}, {"54",	"553"}, {"23",	"555"}, {"47",	"555"}, {"73",	"555"}, {"08",	"558"}, {"08",	"560"}, {"44",	"560"}, {"52",	"560"}, {"73",	"563"}, {"76",	"563"}, {"88",	"564"}, {"52",	"565"}, {"50",	"568"}, {"86",	"568"}, {"86",	"569"}, {"20",	"570"}, {"23",	"570"}, {"47",	"570"}, {"86",	"571"}, {"15",	"572"}, {"25",	"572"}, {"66",	"572"}, {"68",	"572"}, {"08",	"573"}, {"19",	"573"}, {"50",	"573"}, {"52",	"573"}, {"68",	"573"}, {"86",	"573"}, {"23",	"574"}, {"68",	"575"}, {"05",	"576"}, {"50",	"577"}, {"05",	"579"}, {"13",	"580"}, {"15",	"580"}, {"23",	"580"}, {"25",	"580"}, {"27",	"580"}, {"05",	"585"}, {"19",	"585"}, {"52",	"585"}, {"73",	"585"}, {"23",	"586"}, {"50",	"590"}, {"05",	"591"}, {"81",	"591"}, {"18",	"592"}, {"25",	"592"}, {"25",	"594"}, {"63",	"594"}, {"66",	"594"}, {"25",	"596"}, {"15",	"599"}, {"25",	"599"}, {"54",	"599"}, {"13",	"600"}, {"15",	"600"}, {"27",	"600"}, {"05",	"604"}, {"47",	"605"}, {"08",	"606"}, {"50",	"606"}, {"76",	"606"}, {"05",	"607"}, {"18",	"610"}, {"25",	"612"}, {"52",	"612"}, {"17",	"614"}, {"20",	"614"}, {"05",	"615"}, {"27",	"615"}, {"41",	"615"}, {"68",	"615"}, {"17",	"616"}, {"73",	"616"}, {"76",	"616"}, {"13",	"620"}, {"15",	"621"}, {"20",	"621"}, {"52",	"621"}, {"19",	"622"}, {"73",	"622"}, {"76",	"622"}, {"73",	"624"}, {"99",	"624"}, {"05",	"628"}, {"05",	"631"}, {"15",	"632"}, {"08",	"634"}, {"08",	"638"}, {"15",	"638"}, {"05",	"642"}, {"25",	"645"}, {"15",	"646"}, {"05",	"647"}, {"13",	"647"}, {"05",	"649"}, {"25",	"649"}, {"13",	"650"}, {"44",	"650"}, {"05",	"652"}, {"17",	"653"}, {"25",	"653"}, {"13",	"654"}, {"13",	"655"}, {"68",	"655"}, {"05",	"656"}, {"13",	"657"}, {"05",	"658"}, {"25",	"658"}, {"05",	"659"}, {"05",	"660"}, {"15",	"660"}, {"23",	"660"}, {"27",	"660"}, {"41",	"660"}, {"47",	"660"}, {"54",	"660"}, {"17",	"662"}, {"25",	"662"}, {"94",	"663"}, {"05",	"664"}, {"15",	"664"}, {"05",	"665"}, {"17",	"665"}, {"97",	"666"}, {"05",	"667"}, {"13",	"667"}, {"15",	"667"}, {"41",	"668"}, {"68",	"669"}, {"91",	"669"}, {"05",	"670"}, {"13",	"670"}, {"23",	"670"}, {"54",	"670"}, {"70",	"670"}, {"76",	"670"}, {"73",	"671"}, {"23",	"672"}, {"13",	"673"}, {"15",	"673"}, {"54",	"673"}, {"68",	"673"}, {"05",	"674"}, {"08",	"675"}, {"23",	"675"}, {"47",	"675"}, {"73",	"675"}, {"15",	"676"}, {"41",	"676"}, {"23",	"678"}, {"52",	"678"}, {"70",	"678"}, {"73",	"678"}, {"05",	"679"}, {"68",	"679"}, {"50",	"680"}, {"54",	"680"}, {"15",	"681"}, {"23",	"682"}, {"66",	"682"}, {"68",	"682"}, {"13",	"683"}, {"50",	"683"}, {"52",	"683"}, {"68",	"684"}, {"08",	"685"}, {"52",	"685"}, {"05",	"686"}, {"15",	"686"}, {"23",	"686"}, {"50",	"686"}, {"68",	"686"}, {"73",	"686"}, {"52",	"687"}, {"66",	"687"}, {"13",	"688"}, {"50",	"689"}, {"68",	"689"}, {"05",	"690"}, {"15",	"690"}, {"63",	"690"}, {"47",	"692"}, {"15",	"693"}, {"19",	"693"}, {"52",	"693"}, {"52",	"694"}, {"15",	"696"}, {"52",	"696"}, {"05",	"697"}, {"19",	"698"}, {"52",	"699"}, {"19",	"701"}, {"70",	"702"}, {"47",	"703"}, {"68",	"705"}, {"47",	"707"}, {"70",	"708"}, {"20",	"710"}, {"50",	"711"}, {"70",	"713"}, {"70",	"717"}, {"25",	"718"}, {"15",	"720"}, {"47",	"720"}, {"52",	"720"}, {"54",	"720"}, {"68",	"720"}, {"15",	"723"}, {"05",	"736"}, {"25",	"736"}, {"76",	"736"}, {"81",	"736"}, {"15",	"740"}, {"25",	"740"}, {"70",	"742"}, {"19",	"743"}, {"25",	"743"}, {"54",	"743"}, {"13",	"744"}, {"25",	"745"}, {"27",	"745"}, {"47",	"745"}, {"68",	"745"}, {"86",	"749"}, {"20",	"750"}, {"15",	"753"}, {"18",	"753"}, {"25",	"754"}, {"15",	"755"}, {"68",	"755"}, {"86",	"755"}, {"05",	"756"}, {"15",	"757"}, {"86",	"757"}, {"08",	"758"}, {"25",	"758"}, {"15",	"759"}, {"13",	"760"}, {"19",	"760"}, {"86",	"760"}, {"05",	"761"}, {"15",	"761"}, {"15",	"762"}, {"15",	"763"}, {"15",	"764"}, {"18",	"756"}, {"25",	"769"}, {"08",	"770"}, {"20",	"770"}, {"41",	"770"}, {"68",	"770"}, {"73",	"770"}, {"70",	"771"}, {"25",	"772"}, {"68",	"773"}, {"99",	"773"}, {"15",	"774"}, {"15",	"776"}, {"17",	"777"}, {"25",	"777"}, {"97",	"777"}, {"15",	"778"}, {"25",	"779"}, {"13",	"780"}, {"19",	"780"}, {"68",	"780"}, {"25",	"781"}, {"18",	"785"}, {"19",	"785"}, {"25",	"785"}, {"52",	"786"}, {"20",	"787"}, {"27",	"787"}, {"52",	"788"}, {"05",	"789"}, {"05",	"790"}, {"15",	"790"}, {"41",	"791"}, {"05",	"792"}, {"25",	"793"}, {"81",	"794"}, {"25",	"797"}, {"41",	"797"}, {"15",	"798"}, {"47",	"798"}, {"91",	"798"}, {"25",	"799"}, {"41",	"799"}, {"27",	"800"}, {"54",	"800"}, {"41",	"801"}, {"15",	"804"}, {"25",	"805"}, {"15",	"806"}, {"19",	"807"}, {"23",	"807"}, {"25",	"807"}, {"41",	"807"}, {"15",	"808"}, {"05",	"809"}, {"19",	"809"}, {"13",	"810"}, {"15",	"810"}, {"27",	"810"}, {"54",	"810"}, {"15",	"814"}, {"25",	"815"}, {"15",	"816"}, {"25",	"817"}, {"05",	"819"}, {"15",	"820"}, {"54",	"820"}, {"68",	"820"}, {"70",	"820"}, {"19",	"821"}, {"15",	"822"}, {"25",	"823"}, {"70",	"823"}, {"76",	"823"}, {"19",	"824"}, {"76",	"828"}, {"08",	"832"}, {"15",	"832"}, {"76",	"834"}, {"15",	"835"}, {"52",	"835"}, {"13",	"836"}, {"05",	"837"}, {"15",	"837"}, {"13",	"838"}, {"52",	"838"}, {"15",	"839"}, {"25",	"839"}, {"25",	"841"}, {"05",	"842"}, {"15",	"842"}, {"25",	"843"}, {"19",	"845"}, {"25",	"845"}, {"76",	"845"}, {"05",	"847"}, {"44",	"847"}, {"08",	"849"}, {"25",	"851"}, {"05",	"854"}, {"73",	"854"}, {"23",	"855"}, {"44",	"855"}, {"68",	"855"}, {"05",	"856"}, {"05",	"858"}, {"18",	"860"}, {"05",	"861"}, {"15",	"861"}, {"68",	"861"}, {"73",	"861"}, {"25",	"862"}, {"76",	"863"}, {"86",	"865"}, {"17",	"867"}, {"25",	"867"}, {"68",	"867"}, {"76",	"869"}, {"73",	"870"}, {"25",	"871"}, {"54",	"871"}, {"41",	"872"}, {"68",	"872"}, {"05",	"873"}, {"13",	"873"}, {"17",	"873"}, {"25",	"873"}, {"73",	"873"}, {"44",	"874"}, {"54",	"874"}, {"25",	"875"}, {"17",	"877"}, {"25",	"878"}, {"15",	"879"}, {"94",	"883"}, {"94",	"884"}, {"05",	"885"}, {"25",	"885"}, {"41",	"885"}, {"52",	"885"}, {"86",	"885"}, {"94",	"885"}, {"94",	"886"}, {"05",	"887"}, {"94",	"887"}, {"94",	"888"}, {"97",	"889"}, {"05",	"890"}, {"76",	"890"}, {"76",	"892"}, {"05",	"893"}, {"13",	"894"}, {"05",	"895"}, {"68",	"895"}, {"76",	"895"}, {"15",	"897"}, {"25",	"898"}, {"25",	"899"}, {"47",	"960"}, {"47",	"980"}};
	
	private final static int TAMANO_CAMPO_TIPO_1 = 53; 
	private final static int TAMANO_CAMPO_TIPO_2 = 896; 
	private final static int TAMANO_CAMPO_TIPO_3 = 851; 
	private final static int TAMANO_CAMPO_TIPO_9 = 9;
	private final static String FORMATO_FECHA = "ddMMyyyy";
	private final static char SEPARADOR_DECIMAL = '.';
	private final static int MAXIMOS_DECIMALES = 2;
	

	public ValidadorDespositosIndividuales() {
		super();
		this.sdf = new SimpleDateFormat(FORMATO_FECHA);
		this.sdf.setLenient(false);
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		String fileName = args[0];
		File inputFile = new File(fileName);
		File outputFile = null;
		outputFile = new File(fileName+".log");
		FileOutputStream os = null;
		FileInputStream is = null;
		DataInputStream in = null;
		BufferedReader br = null;

		try{
			is = new FileInputStream(inputFile);
			in = new DataInputStream(is);
			br = new BufferedReader(new InputStreamReader(in));
			os = new FileOutputStream(outputFile);
			if(outputFile.exists()) {
				outputFile.delete();
			}
			outputFile.createNewFile();
			
			ValidadorDespositosIndividuales validador = new ValidadorDespositosIndividuales();
			Format format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
			Date date = new Date();
	
			validador.log(os,"#####################################################");
			validador.log(os,"## VALIDACIN DE FORMATO DE DEPSITOS INDIVIDUALES ##");
			validador.log(os,"##                      FOGAFIN                    ##");
			validador.log(os,"##             Versin: 2017-09-20 17544           ##");
			validador.log(os,"#####################################################");
			validador.log(os,"Inicio: " + format.format(date));
			validador.log(os,"");
	
			boolean result = validador.validar(br, os, fileName);
	
			date = new Date();
			validador.log(os,"");
			validador.log(os,"Fin: " + format.format(date));
			validador.log(os,"######################################################");
			if(result) {
				System.exit(1);
			} else {
				System.exit(0);
			}
		} catch(FileNotFoundException e) {
			System.out.println("ERROR: No es posible abrir el archivo.");
		} catch(IOException e) {
			System.out.println("ERROR: Fallo en la lectura/escritura del archivo");
		} finally {
			try {
				if(os != null) os.close();
				if(br != null) br.close();
				if(in != null) in.close();
				if(is != null) is.close();
			}
			catch(Exception e) {
				System.out.println("ERROR: Fallo general");
			}
		}

	}

	private boolean validar(BufferedReader br, FileOutputStream os, String fileName) throws IOException {
		String line;
		String trimedLine;
		int dataLineCounter = 1;
		int fileLineCounter = 1;
		boolean hasFinalLine = false;
		boolean fileOK = true;

		while ((line = br.readLine()) != null) {
			trimedLine = line.trim();
			if (trimedLine != "") {
				if (dataLineCounter == 1) { // Primera lnea. Debe ser registro tipo 1
					if(!this.validateFirstLine(os, line, fileLineCounter)) {
					  hasFinalLine = true; //Para que no salga el error de fin de archivo
					  fileOK = false;
					  break;
					}
					if(!this.validateFileName(os, line, fileName)) {
					  hasFinalLine = true; //Para que no salga el error de fin de archivo
					  fileOK = false;
					  break;
					}
				} else if (dataLineCounter == totalLines) { // ltima lnea. Debe ser registro tipo 9.
					if(!this.validateLastLine(os, line, dataLineCounter, fileLineCounter)) {
						break;
					} else {
						hasFinalLine = true;
					}
				} else if (dataLineCounter > totalLines) { // ERROR: Hay datos despus del registro tipo 9
					this.logError(os, fileLineCounter, "El archivo contiene datos despus del registro de FIN DEL ARCHIVO");
					fileOK = false;
					break;
				} else {// Registro tipo 2  3
					if(!validateLine(os, line, dataLineCounter, fileLineCounter)) {
						fileOK = false;
					}
				}
				dataLineCounter++;
			}
			fileLineCounter++;
		}
		
		if (!hasFinalLine) {
			this.logError(os, dataLineCounter, "El archivo no contiene el registro de FIN DEL ARCHIVO");
			fileOK = false;
		}
	
		if(fileOK) {
			if(this.totalSum.setScale(2, RoundingMode.HALF_UP).compareTo(this.headerSum)!= 0) {
				//this.log(os, "Mensaje: Suma [" + Math.round(this.totalSum*100.0)/100.0 + "]: Encabezado [" + this.headerSum + "]: ");
				this.logError(os, 1, "El campo 7 del registro 1 [" + this.headerSum + "] no corresponde a la suma de los campos 17 y 19 de los registros tipo 2 [" + this.totalSum.setScale(2, RoundingMode.HALF_UP) + "].");
				fileOK = false;
			}
		}
		
		if (fileOK) {
			this.logInfo(os,"La validacin del archivo fue exitosa.");
		}
		
		return fileOK;
	}
	
	private boolean validateFileName(FileOutputStream os, String line, String fileName) throws IOException {
	  String fileNameToCompare;
	  String fileNameModified;
	  boolean isValid = true;
	  
	  fileNameToCompare = "0" + line.substring(9, 11);
	  fileNameToCompare +=  line.substring(14, 17);
	  fileNameToCompare +=  line.substring(17, 25);
	  
	  //Eliminando rutas absolutas
	  while(fileName.contains("\\"))
		  fileName = fileName.substring( fileName.indexOf("\\")+1 , fileName.length() );
	  
	  while(fileName.contains("/"))
		  fileName = fileName.substring( fileName.indexOf("/")+1 , fileName.length() );
	  
	  fileNameModified = fileName.substring(0, fileName.indexOf("."));
	  
	  if( !fileNameModified.substring(0, 6).equals(fileNameToCompare.substring(0, 6)) ){
	  	  this.logError(os,0, "Los valores de sector y entidad en el nombre del archivo no coinciden con los valores correspondientes en el registro tipo1." );
	  	  isValid = false;
	  }
	  
	  if( !fileNameModified.substring(6).equals(fileNameToCompare.substring(6)) ){
	  	  this.logError(os,0, "La fecha en el nombre del archivo no coinciden con los valores correspondientes en el registro tipo1." );
	  	  isValid = false;
	  }
	  
	  return isValid;
	}
	
	private boolean validateFirstLine(FileOutputStream os, String line, int fileLineCounter) throws IOException {
		boolean status = true;
		String field = null;
		if(line.length() != TAMANO_CAMPO_TIPO_1) {
			this.logError(os, fileLineCounter, "El tamao del registro de CONTROL Y ENCABEZADO DE LA INFORMACIN debe ser de " + TAMANO_CAMPO_TIPO_1 + " caracteres.");
			return false;
		}
		if(!validateSequence(os, line, 1, fileLineCounter)) {//Campo 1
			return false;
		}
		if(!line.substring(8, 9).equals("1")) {//Campo 2
			this.logError(os, fileLineCounter, "El tipo de registro (campo 2) no es vlido");
			status = false;
		}
		if(!this.validateIntegerField(os, line, fileLineCounter, 9, 2, 3)) { //Campo 3
			status = false;
		}
		if(!this.validateIntegerField(os, line, fileLineCounter, 11, 6, 4)) { //Campo 4
			status = false;
		}
		if(!this.validateDateField(os, line, fileLineCounter, 17, 5)) { //Campo 5
			status = false;
		}
		if(!this.validateIntegerField(os, line, fileLineCounter, 25, 8, 6)) { //Campo 6
			status = false;
		} else {
			field = line.substring(25, 25 + 8);
			this.totalLines = Integer.parseInt(field);
		}
		if(!this.validateDecimalField(os, line, fileLineCounter, 33, 20, 7)) { //Campo 7
			status = false;
		} else {
			field = line.substring(33, 33 + 20);
			this.headerSum = new BigDecimal(field);
		}
		
		return status;
	}
	
	private boolean validateLine(FileOutputStream os, String line, int dataLineCounter, int fileLineCounter) throws IOException {
		String type;
		if(line.length() != TAMANO_CAMPO_TIPO_2 && line.length() != TAMANO_CAMPO_TIPO_3) {
			this.logError(os, fileLineCounter, "El nmero de caracteres del registro es incorrecto.");
			return false;
		}
		if(!validateSequence(os, line, dataLineCounter, fileLineCounter)) {//Campo 1
			return false;
		}
		type = line.substring(8, 9); //Campo 2 
		if((!type.equals("2")) && (!type.equals("3"))) {
			this.logError(os, fileLineCounter, "El tipo de registro (campo 2) no es vlido");
			return false;
		}
		if(type.equals("2")) {
			return validateLineType2(os, line, dataLineCounter, fileLineCounter);
		} else if(type.equals("3")) {
			return validateLineType3(os, line, dataLineCounter, fileLineCounter);
		}
		return false;
	}
	
	private boolean validateLineType2(FileOutputStream os, String line, int dataLineCounter, int fileLineCounter) throws IOException {
		boolean status = true;
		String[] field3Values = {"0", "1", "2", "3", "4", "5", "6", "7", "8"};
		String[] field5Values = {"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "N"};
		String[] field6Values = {"0", "1", "2", "3"};		
		String[] field7Values = {"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "NA"};
		String[] field14Values = {"00", "05", "08", "11", "13", "15", "17", "18", "19", "20", "23", "25", "27", "41", "44", "47", "50", "52", "54", "63", "66", "68", "70", "73", "76", "81", "85", "86", "88", "91", "94", "95", "97", "99"};
		String[] field15Values = {"000", "001", "002", "003", "004", "006", "010", "011", "013", "015", "016", "019", "020", "021", "022", "024", "025", "026", "029", "030", "031", "032", "034", "035", "036", "038", "040", "041", "042", "043", "044", "045", "047", "050", "051", "052", "053", "054", "055", "058", "059", "060", "062", "065", "067", "068", "073", "074", "075", "077", "078", "079", "081", "083", "086", "087", "088", "090", "091", "092", "093", "094", "095", "097", "098", "099", "100", "101", "104", "106", "107", "109", "110", "111", "113", "114", "120", "121", "122", "123", "124", "125", "126", "128", "129", "130", "131", "132", "134", "135", "136", "137", "138", "139", "140", "141", "142", "145", "147", "148", "150", "151", "152", "154", "160", "161", "162", "167", "168", "169", "170", "172", "174", "175", "176", "178", "179", "180", "181", "182", "183", "185", "187", "188", "189", "190", "197", "200", "203", "204", "205", "206", "207", "209", "210", "211", "212", "214", "215", "217", "218", "219", "220", "221", "222", "223", "224", "225", "226", "227", "228", "229", "230", "232", "233", "234", "235", "236", "237", "238", "239", "240", "243", "244", "245", "246", "247", "248", "250", "251", "254", "255", "256", "258", "260", "261", "263", "264", "265", "266", "268", "269", "270", "271", "272", "275", "276", "279", "281", "282", "283", "284", "286", "287", "288", "290", "293", "295", "296", "297", "298", "299", "300", "302", "306", "307", "308", "310", "312", "313", "315", "317", "318", "319", "320", "321", "322", "323", "324", "325", "326", "327", "328", "330", "332", "335", "339", "343", "344", "347", "349", "350", "352", "353", "354", "355", "356", "357", "359", "360", "361", "362", "364", "367", "368", "370", "372", "376", "377", "378", "380", "381", "383", "385", "386", "388", "390", "392", "394", "396", "397", "398", "399", "400", "401", "402", "403", "405", "406", "407", "408", "410", "411", "413", "417", "418", "419", "420", "421", "425", "426", "427", "429", "430", "432", "433", "435", "436", "438", "440", "442", "443", "444", "446", "449", "450", "455", "456", "458", "460", "461", "464", "466", "467", "468", "469", "470", "473", "475", "476", "479", "480", "483", "486", "488", "489", "490", "491", "494", "495", "497", "498", "500", "501", "502", "503", "504", "506", "507", "508", "511", "513", "514", "516", "517", "518", "520", "522", "523", "524", "530", "531", "532", "533", "535", "536", "537", "540", "541", "542", "543", "545", "547", "548", "549", "550", "551", "553", "555", "558", "560", "563", "564", "565", "568", "569", "570", "571", "572", "573", "574", "575", "576", "577", "579", "580", "585", "586", "590", "591", "592", "594", "596", "599", "600", "604", "605", "606", "607", "610", "612", "614", "615", "616", "620", "621", "622", "624", "628", "631", "632", "634", "638", "642", "645", "646", "647", "649", "650", "652", "653", "654", "655", "656", "657", "658", "659", "660", "662", "663", "664", "665", "666", "667", "668", "669", "670", "671", "672", "673", "674", "675", "676", "678", "679", "680", "681", "682", "683", "684", "685", "686", "687", "688", "689", "690", "692", "693", "694", "696", "697", "698", "699", "701", "702", "703", "705", "707", "708", "710", "711", "713", "717", "718", "720", "723", "736", "740", "742", "743", "744", "745", "749", "750", "753", "754", "755", "756", "757", "758", "759", "760", "761", "762", "763", "764", "765", "769", "770", "771", "772", "773", "774", "776", "777", "778", "779", "780", "781", "785", "786", "787", "788", "789", "790", "791", "792", "793", "794", "797", "798", "799", "800", "801", "804", "805", "806", "807", "808", "809", "810", "814", "815", "816", "817", "819", "820", "821", "822", "823", "824", "828", "832", "834", "835", "836", "837", "838", "839", "841", "842", "843", "845", "847", "849", "851", "854", "855", "856", "858", "860", "861", "862", "863", "865", "867", "869", "870", "871", "872", "873", "874", "875", "877", "878", "879", "883", "884", "885", "886", "887", "888", "889", "890", "892", "893", "894", "895", "897", "898", "899", "960", "980"};
		String[] field19Values = {"00", "01", "02", "03", "04", "05", "06", "07", "08", "09"};
		String[] field21Values = {"0", "1", "2"};
		String[] field22Values = {"0", "1", "2"};
		String[] field23Values = {"0", "1"};
		String[] field25Values = {"+", "-"};
		String[] field27Values = {"0", "1", "2", "3", "4", "5", "6"};
		int field6 = Integer.parseInt(line.substring(26, 26 + 1));
		
		if(line.length() != TAMANO_CAMPO_TIPO_2) {
			this.logError(os, fileLineCounter, "El nmero de caracteres del registro es incorrecto.");
			return false;
		}
		if(!this.validateList(os, line, fileLineCounter, 9, 1, field3Values, 3)) { //Campo 3
			status = false;
		}		
		if(!this.validateNotEmptyAlphanumericField(os, line, fileLineCounter, 10, 15, 4)) { //Campo 4
			status = false;
		}		
		if(!this.validateList(os, line, fileLineCounter, 25, 1, field5Values, 5)) { //Campo 5
			status = false;
		}
		
		if(!this.validateList(os, line, fileLineCounter, 26, 1, field6Values, 6)) { //Campo 6
			status = false;
		}		
		if(field6 == 0){
        	if(!this.validateNotEmptyAlphanumericField(os, line, fileLineCounter, 29, 70, 8)) { //Campo 8
        		status = false;
        	}
        	//Campo 9 no es necesario validarlo
        	if(!this.validateNotEmptyAlphanumericField(os, line, fileLineCounter, 169, 70, 10)) { //Campo 10
        		status = false;
        	}
        	//Campo 11 no es necesario validarlo
		}
		if(field6 != 0){
			if(!this.validateNotEmptyAlphanumericField(os, line, fileLineCounter, 309, 200, 12)) { //Campo 12
				status = false;
			}
		}
		
		if(!this.validateList(os, line, fileLineCounter, 27, 2, field7Values, 7)) { //Campo 7
			status = false;
		}	
		if(!this.validateNotEmptyAlphanumericField(os, line, fileLineCounter, 509, 200, 13)) { //Campo 13
			status = false;
		}	
		if(!this.validateList(os, line, fileLineCounter, 709, 2, field14Values, 14)) { //Campo 14
			status = false;
		}
		if(!this.validateList(os, line, fileLineCounter, 711, 3, field15Values, 15)) { //Campo 15
			status = false;
		}
		if(status) {
			if(!this.validateMatrix(os, line, fileLineCounter, 709, 2, 711, 3, ValidadorDespositosIndividuales.matrizCiudades, 14, 15)){//Campo 15 respecto al 14
				status = false;
			}
		}
		//Campo 16 no es necesario validarlo
		//Campo 17 no es necesario validarlo
		//Campo 18 no es necesario validarlo
		if(!this.validateList(os, line, fileLineCounter, 824, 2, field19Values, 19)) { //Campo 19
			status = false;
		}
		if(!this.validateNotEmptyAlphanumericField(os, line, fileLineCounter, 826, 25, 20)) { //Campo 20
			status = false;
		}	
		if(!this.validateList(os, line, fileLineCounter, 851, 1, field21Values, 21)) { //Campo 21
			status = false;
		}
		if(!this.validateList(os, line, fileLineCounter, 852, 1, field22Values, 22)) { //Campo 22
			status = false;
		}
		if(!this.validateList(os, line, fileLineCounter, 853, 1, field23Values, 23)) { //Campo 23
			status = false;
		}
		if(!this.validateDecimalField(os, line, fileLineCounter, 854, 20, 24)) { //Campo 24
			status = false;
		}	
		if(!this.validateList(os, line, fileLineCounter, 874, 1, field25Values, 25)) { //Campo 25
			status = false;
		}
		if(!this.validateDecimalField(os, line, fileLineCounter, 875, 20, 26)) { //Campo 26
			status = false;
		}
		if(!this.validateList(os, line, fileLineCounter, 895, 1, field27Values, 27)) { //Campo 27
			status = false;
		}
		
		if(status) {
			BigDecimal sign = new BigDecimal(1);
			BigDecimal field24 = new BigDecimal(line.substring(854, 874));
			//this.log(os, "Mensaje: Saldo [" + field17 + "]: ");
			BigDecimal field26 = new BigDecimal(line.substring(875, 895));
			//this.log(os, "Mensaje: Interes [" + field19 + "]: ");
			if(line.substring(874,875).equals("-")) {
				sign = new BigDecimal(-1);
			}
			this.totalSum = this.totalSum.add(sign.multiply(field24));
			this.totalSum = this.totalSum.add(field26);
		}
		return status;
	}
	
	
	private boolean validateLineType3(FileOutputStream os, String line, int dataLineCounter, int fileLineCounter) throws IOException {
		boolean status = true;
		String[] field3Values = {"0", "1", "2", "3", "4", "5", "6", "7", "8"};
		String[] field5Values = {"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "N"};
		String[] field6Values = {"0", "1", "2", "3"};
		String[] field7Values = {"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "NA"};
		String[] field14Values = {"00", "05", "08", "11", "13", "15", "17", "18", "19", "20", "23", "25", "27", "41", "44", "47", "50", "52", "54", "63", "66", "68", "70", "73", "76", "81", "85", "86", "88", "91", "94", "95", "97", "99"};
		String[] field15Values = {"000", "001", "002", "003", "004", "006", "010", "011", "013", "015", "016", "019", "020", "021", "022", "024", "025", "026", "029", "030", "031", "032", "034", "035", "036", "038", "040", "041", "042", "043", "044", "045", "047", "050", "051", "052", "053", "054", "055", "058", "059", "060", "062", "065", "067", "068", "073", "074", "075", "077", "078", "079", "081", "083", "086", "087", "088", "090", "091", "092", "093", "094", "095", "097", "098", "099", "100", "101", "104", "106", "107", "109", "110", "111", "113", "114", "120", "121", "122", "123", "124", "125", "126", "128", "129", "130", "131", "132", "134", "135", "136", "137", "138", "139", "140", "141", "142", "145", "147", "148", "150", "151", "152", "154", "160", "161", "162", "167", "168", "169", "170", "172", "174", "175", "176", "178", "179", "180", "181", "182", "183", "185", "187", "188", "189", "190", "197", "200", "203", "204", "205", "206", "207", "209", "210", "211", "212", "214", "215", "217", "218", "219", "220", "221", "222", "223", "224", "225", "226", "227", "228", "229", "230", "232", "233", "234", "235", "236", "237", "238", "239", "240", "243", "244", "245", "246", "247", "248", "250", "251", "254", "255", "256", "258", "260", "261", "263", "264", "265", "266", "268", "269", "270", "271", "272", "275", "276", "279", "281", "282", "283", "284", "286", "287", "288", "290", "293", "295", "296", "297", "298", "299", "300", "302", "306", "307", "308", "310", "312", "313", "315", "317", "318", "319", "320", "321", "322", "323", "324", "325", "326", "327", "328", "330", "332", "335", "339", "343", "344", "347", "349", "350", "352", "353", "354", "355", "356", "357", "359", "360", "361", "362", "364", "367", "368", "370", "372", "376", "377", "378", "380", "381", "383", "385", "386", "388", "390", "392", "394", "396", "397", "398", "399", "400", "401", "402", "403", "405", "406", "407", "408", "410", "411", "413", "417", "418", "419", "420", "421", "425", "426", "427", "429", "430", "432", "433", "435", "436", "438", "440", "442", "443", "444", "446", "449", "450", "455", "456", "458", "460", "461", "464", "466", "467", "468", "469", "470", "473", "475", "476", "479", "480", "483", "486", "488", "489", "490", "491", "494", "495", "497", "498", "500", "501", "502", "503", "504", "506", "507", "508", "511", "513", "514", "516", "517", "518", "520", "522", "523", "524", "530", "531", "532", "533", "535", "536", "537", "540", "541", "542", "543", "545", "547", "548", "549", "550", "551", "553", "555", "558", "560", "563", "564", "565", "568", "569", "570", "571", "572", "573", "574", "575", "576", "577", "579", "580", "585", "586", "590", "591", "592", "594", "596", "599", "600", "604", "605", "606", "607", "610", "612", "614", "615", "616", "620", "621", "622", "624", "628", "631", "632", "634", "638", "642", "645", "646", "647", "649", "650", "652", "653", "654", "655", "656", "657", "658", "659", "660", "662", "663", "664", "665", "666", "667", "668", "669", "670", "671", "672", "673", "674", "675", "676", "678", "679", "680", "681", "682", "683", "684", "685", "686", "687", "688", "689", "690", "692", "693", "694", "696", "697", "698", "699", "701", "702", "703", "705", "707", "708", "710", "711", "713", "717", "718", "720", "723", "736", "740", "742", "743", "744", "745", "749", "750", "753", "754", "755", "756", "757", "758", "759", "760", "761", "762", "763", "764", "765", "769", "770", "771", "772", "773", "774", "776", "777", "778", "779", "780", "781", "785", "786", "787", "788", "789", "790", "791", "792", "793", "794", "797", "798", "799", "800", "801", "804", "805", "806", "807", "808", "809", "810", "814", "815", "816", "817", "819", "820", "821", "822", "823", "824", "828", "832", "834", "835", "836", "837", "838", "839", "841", "842", "843", "845", "847", "849", "851", "854", "855", "856", "858", "860", "861", "862", "863", "865", "867", "869", "870", "871", "872", "873", "874", "875", "877", "878", "879", "883", "884", "885", "886", "887", "888", "889", "890", "892", "893", "894", "895", "897", "898", "899", "960", "980"};
		String[] field20Values = {"00", "01", "02", "03", "04", "05", "06", "07", "08", "09"};
		int field6 = Integer.parseInt(line.substring(26, 26 + 1));
		
		if(line.length() != TAMANO_CAMPO_TIPO_3) {
			this.logError(os, fileLineCounter, "El nmero de caracteres del registro es incorrecto.");
			return false;
		}
		if(!this.validateList(os, line, fileLineCounter, 9, 1, field3Values, 3)) { //Campo 3
			status = false;
		}
		
		if(!this.validateNotEmptyAlphanumericField(os, line, fileLineCounter, 10, 15, 4)) { //Campo 4
			status = false;
		}
		if(!this.validateList(os, line, fileLineCounter, 25, 1, field5Values, 5)) { //Campo 5
			status = false;
		}
		if(!this.validateList(os, line, fileLineCounter, 26, 1, field6Values, 6)) { //Campo 6
			status = false;
		}
		
		if(field6 == 0){
          	if(!this.validateNotEmptyAlphanumericField(os, line, fileLineCounter, 29, 70, 8)) { //Campo 8
        		status = false;
          	}
        	//Campo 9 no es necesario validarlo
        	if(!this.validateNotEmptyAlphanumericField(os, line, fileLineCounter, 169, 70, 10)) { //Campo 10
        		status = false;
        	}
        	//Campo 11 no es necesario validarlo
		}
		if(field6 != 0){
    		if(!this.validateNotEmptyAlphanumericField(os, line, fileLineCounter, 309, 200, 12)) { //Campo 12
    			status = false;
    		}
		}
		
		if(!this.validateList(os, line, fileLineCounter, 27, 2, field7Values, 7)) { //Campo 7
			status = false;
		}
		if(!this.validateNotEmptyAlphanumericField(os, line, fileLineCounter, 509, 200, 13)) { //Campo 13
			status = false;
		}
		if(!this.validateList(os, line, fileLineCounter, 709, 2, field14Values, 14)) { //Campo 14
			status = false;
		}
		if(!this.validateList(os, line, fileLineCounter, 711, 3, field15Values, 15)) { //Campo 15
			status = false;
		}
		if(status) {
			if(!this.validateMatrix(os, line, fileLineCounter, 709, 2, 711, 3, ValidadorDespositosIndividuales.matrizCiudades, 14, 15)){//Campo 15 respecto al 14
				status = false;
			}
		}
		//Campo 16 no es necesario validarlo
		//Campo 17 no es necesario validarlo
		//Campo 18 no es necesario validarlo
		if(!this.validateNotEmptyAlphanumericField(os, line, fileLineCounter, 824, 25, 19)) { //Campo 19
			status = false;
		}
		if(!this.validateList(os, line, fileLineCounter, 849, 2, field20Values, 20)) { //Campo 20
			status = false;
		}
		
		return status;
	}	
	
	private boolean validateMatrix(FileOutputStream os, String line, int fileLineCounter, int startIndex1, int size1, int startIndex2, int size2, String[][] matrix, int fieldPosition1, int fieldPosition2) throws IOException {
		boolean status = false;
		String field1 = line.substring(startIndex1, startIndex1 + size1);
		String field2 = line.substring(startIndex2, startIndex2 + size2);
		for(int i = 0; i < matrix.length; i++) {
			if(matrix[i][0].equals(field1) && matrix[i][1].equals(field2)) {
				status = true;
			}
		}
		if(!status) {
			this.logError(os, fileLineCounter, "El conjunto de valores de los campos " + fieldPosition1 + " y " + fieldPosition2 + " no son vlidos");
		}
		return status;
	}
	
	private boolean validateList(FileOutputStream os, String line, int fileLineCounter, int startIndex, int size, String[] values,int fieldPosition) throws IOException {
		boolean matchValue = false;
		String value = line.substring(startIndex, startIndex + size);
		for(int i = 0; i < values.length; i++) {
			if(value.equals(values[i])){
				matchValue = true;
				break;
			}
		}
		if(!matchValue) {
			this.logError(os, fileLineCounter, "El valor del campo " + fieldPosition + " no es vlido.");
			return false;
		}
		return true;
	}
	private boolean validateLastLine(FileOutputStream os, String line, int dataLineCounter, int fileLineCounter) throws IOException {
		boolean status = true;
		if(line.length() != TAMANO_CAMPO_TIPO_9) {
			this.logError(os, fileLineCounter, "El tamao del registro de FIN DEL ARCHIVO debe ser de " + TAMANO_CAMPO_TIPO_9 + " caracteres.");
			return false;
		}
		if(!validateSequence(os, line, dataLineCounter, fileLineCounter)) {//Campo 1
			return false;
		}
		if(!line.substring(8, 9).equals("9")) {//Campo 2
			this.logError(os, fileLineCounter, "El tipo de registro (campo 2) no es vlido");
			status = false;
		}	
		return status;
	}

	private void log(FileOutputStream os, String message) throws IOException {
		message = message + "\r\n";
		os.write(message.getBytes());
		os.flush();
	}
	
	private void logError(FileOutputStream os, int line, String error) throws IOException {
		this.log(os, "ERROR: Lnea [" + line + "]: " + error);
	}
	
	private void logInfo(FileOutputStream os, String info) throws IOException {
		this.log(os, "INFO: " + info);
	}
	
	private boolean validateSequence(FileOutputStream os, String line, int sequence, int fileLineCounter) throws IOException {
		String field = line.substring(0, 8);
		if(validateInteger(field)){
			int lineSequence = Integer.parseInt(field);
			if(lineSequence != sequence) {
				this.logError(os, fileLineCounter, "El campo 'Nmero de secuencia' no coincide con la secuencia de la lnea.");
				return false;
			}
		} else {
			this.logError(os, fileLineCounter, "El campo 'Nmero de secuencia' no es un nmero entero vlido");
			return false;
		}
		return true;
	}
	
	private boolean validateInteger(String text) {
		for(int i = 0; i < text.length(); i++) {
			char digit = text.charAt(i);
			if(digit < '0' || digit > '9') { //Si contiene caracteres invlidos
				return false;
			}
		}
		return true;
	}
	
	private boolean validateDecimal(String text) {
		int pointsCount = 0;
		int pointIndex = -1;
		for(int i = 0; i < text.length(); i++) {
			char digit = text.charAt(i);
			if((digit < '0' || digit > '9') && digit != SEPARADOR_DECIMAL) { //Si contiene caracteres invlidos
				return false;
			}
			if(digit == '.') {
				pointsCount++;
				pointIndex = i;
			}
		}
		if(pointsCount > 1) {//Si hay ms de un punto
			return false;
		}
		if(pointsCount == 1) {
			if(pointIndex < text.length() - (MAXIMOS_DECIMALES + 1)) { //Si hay ms de 2 decimales
				return false;
			}
		}
		return true;
	}
	
	private boolean validateAlphanumericNotEmpty(String text) {
		text = text.trim();
		if(text.length()> 0 && text.charAt(0) != ' ') {
			return true;
		}
		return false;
	}
	
	private boolean validateIntegerField(FileOutputStream os, String line, int fileLineCounter, int startIndex, int size, int fieldPosition) throws IOException {
		String number = line.substring(startIndex, startIndex + size);
		if(!validateInteger(number)) {
			this.logError(os,fileLineCounter, "El campo " + fieldPosition + " no es un nmero entero vlido.");
			return false;
		}
		return true;
	}
	
	private boolean validateDateField(FileOutputStream os, String line, int fileLineCounter, int startIndex, int fieldPosition) throws IOException {
		String dateString = line.substring(startIndex, startIndex + 8);
		try {
			this.sdf.parse(dateString);
		} catch (ParseException e) {
			this.logError(os, fileLineCounter, "La fecha del campo " + fieldPosition + " no es vlida.");
			return false;
		}
		return true;
	}
	
	private boolean validateDecimalField(FileOutputStream os, String line, int fileLineCounter, int startIndex, int size, int fieldPosition) throws IOException {
		String number = line.substring(startIndex, startIndex + size);
		if(!validateDecimal(number)) {
			this.logError(os,fileLineCounter, "El campo " + fieldPosition + " no es un nmero decimal vlido.");
			return false;
		}
		return true;
	}
	
	private boolean validateNotEmptyAlphanumericField(FileOutputStream os, String line, int fileLineCounter, int startIndex, int size, int fieldPosition) throws IOException {
		String text = line.substring(startIndex, startIndex + size);
		if(!validateAlphanumericNotEmpty(text)) {
			this.logError(os, fileLineCounter, "El texto del campo " + fieldPosition + " est vaco.");
			return false;
		}
		return true;
	}

}
